/***********************************
 *						           *
 * ļ: 07 ͼ\05 SpanningTree *
 * 						           *
 * ļ: SpanningTree.c          *
 *    	    			           *
 *   : 7.77.8                * 
 *    	    			           *
 ***********************************/

#ifndef SPANNINGTREE_C
#define SPANNINGTREE_C

#include "SpanningTree.h"

/*TTTT[
U 㷨7.7U 
^TTTT*/
void DFSForest(MGraph G, CSTree *T)
{
	int v;
	CSTree p, q;
	
	InitTree_CS(T);
	
	for(v=1; v<=G.vexnum; v++)
		visited[v] = FALSE;
	
	for(v=1; v<=G.vexnum; v++)
	{
		if(!visited[v])							//vΪµĸ 
		{
			p = (CSTree)malloc(sizeof(CSNode));	//
			if(!p)
				exit(OVERFLOW);
			p->data = GetVex_M(G, v);
			p->firstchild = p->nextsibling = NULL;
			
			if(!(*T))							//ǵһĸ 
				*T = p;
			else								//ĸǰһֵܣ 
				q->nextsibling = p;
			
			q = p;								//qָʾǰĸ 
			DFSTree(G, v, &p);					//pΪ 
		}
	}
}

/*TTTT[
U 㷨7.8U 
^TTTT*/
void DFSTree(MGraph G, int v, CSTree *T)
{
	Status first;
	int w;
	CSTree p, q;
		
	visited[v] = TRUE;
	first = TRUE;
	
	for(w=FirstAdjVex_M(G, G.vexs[v]); w; w=NextAdjVex_M(G, G.vexs[v], G.vexs[w]))
	{
		if(!visited[w])
		{
			p = (CSTree)malloc(sizeof(CSNode));		//亢ӽ 
			if(!p)
				exit(OVERFLOW);
			p->data = GetVex_M(G, w);
			p->firstchild = p->nextsibling = NULL;
			
			if(first)
			{
				(*T)->firstchild = p;
				first = FALSE;
			}
			else
				q->nextsibling = p;	
		
			q = p;
			DFSTree(G, w, &q);
		}
	}
}

#endif
